//+------------------------------------------------------------------+
//|                                                Trend Traffic.mq4 |
//|                                    Copyright  2006, Nick Barker |
//|                                       http://www.tradingintl.com |
//|Mod:                                                              |      
//|Kalenzo : bartlomiej.gorski@gmail.com                             |
//|I Colorized bars at the main chart window.                        |            
//+------------------------------------------------------------------+
#property  copyright "Copyright  2006, Nicholas Barker"
#property  link      "http://www.tradingintl.com"
#property  link      "nick@barker.net"

#property  indicator_chart_window
#property  indicator_buffers 2

#property  indicator_color1  Lime
#property  indicator_color2  Yellow


extern int High_Period_Comparison=60;
extern int FastEMA=10,SlowEMA=16;
extern double RedZone=0.5;
extern int SpeedZone=8;
extern int BarsToCalculate = 500;
int L1,L2;
//---- indicator buffers
double     ExtBuffer0[];
double     ExtBuffer1[];
double     ExtBuffer2[];
double     ExtBuffer3[];
double     ExtBuffer4[];
double     ExtBuffer5[];
double     ExtBuffer6[];
double     STD[];
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
int init()
  {
   
   IndicatorBuffers(7); 

   SetIndexStyle(0,DRAW_HISTOGRAM);
   SetIndexStyle(1,DRAW_HISTOGRAM);
   SetIndexStyle(2,DRAW_NONE);
   SetIndexStyle(3,DRAW_NONE);
   SetIndexStyle(4,DRAW_NONE);
   SetIndexStyle(5,DRAW_NONE);
   SetIndexStyle(6,DRAW_NONE);
   
   IndicatorDigits(Digits+2);
   SetIndexDrawBegin(0,38);
   SetIndexDrawBegin(1,38);
   SetIndexDrawBegin(2,38);
   SetIndexDrawBegin(3,38);
   
   SetIndexBuffer(0,ExtBuffer1);
   SetIndexBuffer(1,ExtBuffer2);
   SetIndexBuffer(2,ExtBuffer5);
   
   SetIndexBuffer(3,ExtBuffer4);
   SetIndexBuffer(4,ExtBuffer3);
   SetIndexBuffer(5,ExtBuffer6);
   SetIndexBuffer(6,STD);
   
   IndicatorShortName("Trend Traffic");
   
   L1= High_Period_Comparison/Period()*FastEMA;
   L2= High_Period_Comparison/Period()*SlowEMA;
   
   return(0);
  }
//+------------------------------------------------------------------+
//| Trend Traffic Light                                              |
//+------------------------------------------------------------------+
int start()
  {
   int    limit = BarsToCalculate;
   double prev,current,cur,pre;
   
   for(int i=0; i<limit; i++)
      ExtBuffer3[i]=iMA(NULL,0,L1,0,MODE_EMA,PRICE_CLOSE,i)-iMA(NULL,0,L2,0,MODE_EMA,PRICE_CLOSE,i);
  
   for(i=0; i<limit; i++){
      ExtBuffer4[i]=iMA(NULL,0,FastEMA,0,MODE_EMA,PRICE_CLOSE,i)-iMA(NULL,0,SlowEMA,0,MODE_EMA,PRICE_CLOSE,i);
      double ss=iStdDev(NULL,0,3,MODE_SMA,0,MODE_CLOSE,i);
      if(ss < 25*Point)STD[i]=ss; else STD[i]=25*Point;
   }
   bool up=true;double upper,lower;bool gr8,le5;
   for(i=limit-1; i>=0; i--){
      cur=STD[i];
      pre=STD[i+1];
      
      if(ExtBuffer3[i]>0){
         gr8=true;le5=false;lower=0;
      }else{
         gr8=false;le5=true;upper=0;
      }
      if(gr8 && ExtBuffer3[i]>upper)upper=ExtBuffer3[i];
      else if(le5 && ExtBuffer3[i]<lower)lower=ExtBuffer3[i];
     
      current=ExtBuffer3[i];
      prev=ExtBuffer3[i+1];
      if(current>prev) up=true;
      if(current<prev) up=false;
      
      if(SpeedZone!=0 && cur >= SpeedZone*Point && cur>pre){
         ExtBuffer6[i]=current;
      }  
      if(gr8){
         if( ExtBuffer3[i]<upper*RedZone){
            ExtBuffer2[i]=Low[i];
            ExtBuffer1[i]=Low[i];
            ExtBuffer5[i]=High[i];
         //   ExtBuffer6[i]=0.0;
         }
         else if(!up){
            ExtBuffer2[i]=High[i];
            ExtBuffer1[i]=Low[i];
            ExtBuffer5[i]=Low[i];
          //  ExtBuffer6[i]=0.0;
         }
         else if(up){
            ExtBuffer1[i]=High[i];
            ExtBuffer2[i]=Low[i];
            ExtBuffer5[i]=Low[i];
        //    ExtBuffer6[i]=0.0;
         }
      }
      else if(le5){
         if(ExtBuffer3[i]>lower*RedZone){
            ExtBuffer2[i]=Low[i];
            ExtBuffer1[i]=Low[i];
            ExtBuffer5[i]=High[i];
         //   ExtBuffer6[i]=0.0;
         }
         else if(!up){
            ExtBuffer1[i]=High[i];
            ExtBuffer2[i]=Low[i];
            ExtBuffer5[i]=Low[i];
      //      ExtBuffer6[i]=0.0;
         }
         else if(up){
            ExtBuffer2[i]=High[i];
            ExtBuffer1[i]=Low[i];
            ExtBuffer5[i]=Low[i];
       //     ExtBuffer6[i]=0.0;
         }
      }
      ExtBuffer0[i]=current;
   }
   return(0);
}

